*                                                                                  ;
 *    Reading in the 1972 PSID data                                                 ;
 *                                                                                  ;
 *            Karen Dynan 8/26/06                                                   ;
 *                                                                                  ;
 *    We read it all in and then output select variables to a flat                  ;
 *    file to be picked up by STATA.                                                ;
 *                                                                                  ;
 
libname psid 'F:\PSID' ;
filename rawdat 'F:\PSID\raw\fam72.raw' ;
 
 data one;
 
   infile 'F:\PSID\72FAM.DAT'  lrecl=994 missover;
   INPUT
   V2401 1-3              V2402 4-7              V2403 8-9
   V2404 10-12            V2405 13-17            V2406 18
   V2407 19               V2408 20               V2409 21
   V2410 22               V2411 23               V2412 24
   V2413 25               V2414 26               V2415 27
   V2416 28               V2417 29-32            V2418 33
   V2419 34-36            V2420 37               V2421 38-40
   V2422 41               V2423 42-46            V2424 47
   V2425 48-52            V2426 53               V2427 54-57
   V2428 58               V2429 59-62            V2430 63
   V2431 64-67            V2432 68               V2433 69
   V2434 70-73            V2435 74               V2436 75-78
   V2437 79               V2438 80-83            V2439 84-87
   V2440 88               V2441 89-92            V2442 93
   V2443 94-97            V2444 98               V2445 99-102
   V2446 103              V2447 104-106          V2448 107
   V2449 108-111          V2450 112              V2451 113-116
   V2452 117              V2453 118-120          V2454 121
   V2455 122-125          V2456 126              V2457 127-130
   V2458 131              V2459 132-135          V2460 136
   V2461 137-140          V2462 141              V2463 142-145
   V2464 146              V2465 147-150          V2466 151
   V2467 152              V2468 153-154          V2469 155
   V2470 156-160 .2       V2471 161-165          V2472 166-169
   V2473 170              V2474 171-173          V2475 174
   V2476 175-178          V2477 179              V2478 180-183
   V2479 184              V2480 185-188          V2481 189
   V2482 190              V2483 191-194          V2484 195
   V2485 196-199          V2486 200              V2487 201-204
   V2488 205              V2489 206-209          V2490 210
   V2491 211              V2492 212              V2493 213-217
   V2494 218              V2495 219              V2496 220
   V2497 221              V2498 222-226          V2499 227
   V2500 228-232          V2501 233              V2502 234
   V2503 235              V2504 236              V2505 237
   V2506 238              V2507 239-243          V2508 244
   V2509 245-249          V2510 250              V2511 251-255
   V2512 256-260          V2513 261              V2514 262-266
   V2515 267-271          V2516 272-276          V2517 277-281
   V2518 282-286          V2519 287              V2520 288
   V2521 289              V2522 290              V2523 291-295
   V2524 296-299          V2525 300-304          V2526 305
   V2527 306-310          V2528 311-315          V2529 316
   V2530 317              V2531 318              V2532 319-322
   V2533 323-326          V2534 327-330          V2535 331-334
   V2536 335-338          V2537 339-347          V2538 348-349
   V2539 350              V2540 351-353          V2541 354-355
   V2542 356-357          V2543 358              V2544 359-360
   V2545 361-362          V2546 363-364          V2547 365
   V2548 366              V2549 367              V2550 368
   V2551 369              V2552 370              V2553 371
   V2554 372              V2555 373              V2556 374
   V2557 375              V2558 376-377          V2559 378
   V2560 379              V2561 380              V2562 381
   V2563 382              V2564 383              V2565 384
   V2566 385              V2567 386              V2568 387
   V2569 388              V2570 389              V2571 390
   V2572 391              V2573 392              V2574 393
   V2575 394              V2576 395              V2577 396
   V2578 397              V2579 398              V2580 399
   V2581 400              V2582 401              V2583 402-403
   V2584 404              V2585 405              V2586 406
   V2587 407              V2588 408              V2589 409
   V2590 410              V2591 411-412          V2592 413
   V2593 414-415          V2594 416              V2595 417-418
   V2596 419-420          V2597 421-422          V2598 423
   V2599 424-426          V2600 427              V2601 428-430
   V2602 431              V2603 432              V2604 433
   V2605 434-436          V2606 437-438          V2607 439-440
   V2608 441              V2609 442              V2610 443
   V2611 444              V2612 445-446          V2613 447
   V2614 448              V2615 449              V2616 450
   V2617 451              V2618 452              V2619 453
   V2620 454-456          V2621 457              V2622 458
   V2623 459              V2624 460              V2625 461-463
   V2626 464              V2627 465              V2628 466
   V2629 467              V2630_1 468            V2630_2 469
   V2631 470              V2632 471-473          V2633 474
   V2634 475              V2635 476              V2636 477
   V2637 478-479          V2638 480              V2639 481-482
   V2640 483-484          V2641 485-486          V2642 487-488
   V2643 489-490          V2644 491              V2645 492
   V2646 493              V2647 494              V2648 495
   V2649 496              V2650 497-499          V2651 500
   V2652 501-503          V2653 504              V2654 505
   V2655 506              V2656 507              V2657 508-509
   V2658 510-511          V2659 512-513          V2660 514
   V2661 515              V2662 516-518          V2663 519
   V2664 520              V2665 521              V2666 522
   V2667 523-525          V2668 526              V2669 527
   V2670 528              V2671 529              V2672 530
   V2673 531-532          V2674 533-534          V2675 535-536
   V2676 537              V2677 538              V2678 539
   V2679 540              V2680 541              V2681 542
   V2682_1 543            V2682_2 544            V2683 545
   V2684 546              V2685 547              V2686 548
   V2687 549              V2688 550              V2689 551-552
   V2690 553              V2691 554              V2692 555
   V2693 556              V2694 557              V2695 558
   V2696 559              V2697 560              V2698 561
   V2699 562              V2700 563-565          V2701 566
   V2702 567              V2703 568              V2704 569
   V2705 570              V2706 571              V2707 572
   V2708 573              V2709 574              V2710 575
   V2711 576              V2712 577              V2713 578
   V2714 579              V2715 580              V2716 581
   V2717 582              V2718 583              V2719 584
   V2720 585              V2721 586              V2722 587
   V2723 588              V2724 589-590          V2725 591
   V2726 592              V2727 593              V2728 594-595
   V2729 596              V2730 597              V2731 598
   V2732 599              V2733 600              V2734 601
   V2735 602              V2736 603              V2737 604
   V2738 605              V2739 606              V2740 607
   V2741 608              V2742 609              V2743 610
   V2744 611              V2745 612              V2746 613
   V2747 614              V2748 615              V2749 616
   V2750 617              V2751 618              V2752 619
   V2753 620              V2754 621              V2755 622
   V2756 623              V2757 624              V2758 625
   V2759 626              V2760 627              V2761 628
   V2762 629              V2763 630              V2764 631
   V2765 632              V2766 633              V2767 634
   V2768 635              V2769 636              V2770 637
   V2771 638              V2772 639              V2773 640
   V2774 641              V2775 642              V2776 643
   V2777_1 644            V2777_2 645            V2778 646
   V2779 647              V2780 648              V2781 649
   V2782 650              V2783 651              V2784 652
   V2785 653              V2786 654              V2787 655
   V2788 656              V2789 657              V2790_1 658
   V2790_2 659            V2791 660              V2792 661-662
   V2793 663-665          V2794 666-667          V2795 668-670
   V2796 671              V2797 672              V2798 673
   V2799 674-675          V2800 676-677          V2801 678-679
   V2802 680-681          V2803 682              V2804 683
   V2805 684              V2806 685-686          V2807 687
   V2808 688              V2809 689              V2810 690-691
   V2811 692              V2812 693              V2813 694
   V2814 695              V2815 696-697          V2816 698-700
   V2817 701              V2818 702              V2819 703
   V2820 704              V2821 705              V2822 706
   V2823 707              V2824 708              V2825 709
   V2826 710              V2827 711              V2828 712
   V2829 713              V2830 714              V2831 715
   V2832 716              V2833 717              V2834 718
   V2835 719-721          V2836 722              V2837 723
   V2838 724              V2839 725              V2840 726
   V2841 727              V2842 728              V2843 729
   V2844 730              V2845 731              V2846 732-735
   V2847 736-739          V2848 740-743          V2849 744
   V2850 745-748          V2851 749-752          V2852 753-757
   V2853 758              V2854 759              V2855 760
   V2856 761              V2857 762              V2858 763
   V2859 764              V2860 765              V2861 766
   V2862 767              V2863 768              V2864 769
   V2865 770-774          V2866 775              V2867 776
   V2868 777-780 .2       V2869 781              V2870 782-784
   V2871 785              V2872 786-789          V2873 790-794
   V2874 795              V2875 796-800          V2876 801-805
   V2877 806              V2878 807-810 .2       V2879 811
   V2880 812-814          V2881 815              V2882 816-819
   V2883 820              V2884 821-825          V2885 826
   V2886 827-830 .2       V2887 831              V2888 832-834
   V2889 835              V2890 836-840          V2891 841
   V2892 842-845          V2893 846-849 .2       V2894 850
   V2895 851-853          V2896 854              V2897 855-857
   V2898 858-861          V2899 862              V2900 863-866 .2
   V2901 867              V2902 868-871          V2903 872
   V2904 873-876          V2905 877              V2906 878-881 .2
   V2907 882              V2908 883-886 .2       V2909 887
   V2910 888              V2911 889              V2912 890
   V2913 891              V2914 892              V2915 893
   V2916 894              V2917 895              V2918 896
   V2919 897-898          V2920 899-900          V2921 901-905
   V2922 906              V2923 907              V2924 908
   V2925 909              V2926 910              V2927 911
   V2928 912-913 .1       V2929 914              V2930 915-916
   V2931 917-920          V2932 921-924          V2933 925
   V2934 926              V2935 927              V2936 928-931
   V2937 932-935          V2938 936              V2939 937
   V2940 938              V2941 939              V2942 940
   V2943 941              V2944 942              V2945 943
   V2946 944              V2947 945              V2948 946
   V2949 947-948          V2950 949-950          V2951 951
   V2952 952              V2953 953              V2954 954
   V2955 955              V2956 956              V2957 957
   V2958 958              V2959 959              V2960 960
   V2961 961              V2962 962              V2963 963
   V2964 964              V2965 965              V2966 966-969
   V2967 970-973          V2968 974-975          V2969 976
   V2970 977-981          V2971 982              V2972 983
   V2973 984              V2974 985              V2975 986
   V2976 987              V2977 988              V2978 989
   V2979 990-993          V2980 994;

* SAS LABEL STATEMENT;

LABEL
   V2401 = "STUDY 768 (WAVE 5)"
   V2402 = "1972 INT #        46:6-9"
   V2403 = "STATE NOW       46:10-11"
   V2404 = "COUNTY NOW      46:12-14"
   V2405 = "ST+CNTY NOW     46:10-14"
   V2406 = "LRGST PLAC/SMSA PSU46:16"
   V2407 = "COVERSHEET COLOR   46:18"
   V2408 = "ONCE REFUSED       46:20"
   V2409 = "PHONE INTERVIEW    46:22"
   V2410 = "CHANGE IN FU COMP  46:24"
   V2411 = "# MOVED INTO FU    46:15"
   V2412 = "REL-HEAD:MOVER IN  46:17"
   V2413 = "# MOVED OUT OF FU  46:19"
   V2414 = "REL-HEAD:MOVER OUT 46:21"
   V2415 = "72 FU COMPOSITION  46:23"
   V2416 = "QUALITY OF MATCH   46:25"
   V2417 = "VALUE OF CARS   46:26-29"
   V2418 = "ACCURACY CAR VALUE 46:30"
   V2419 = "SAVE CAR REPAIR 46:31-33"
   V2420 = "ACC OF SAVED CAR   46:34"
   V2421 = "HRS CAR REPAIR  46:35-37"
   V2422 = "ACC HRS CAR REPAIR 46:38"
   V2423 = "HOUSE VALUE     46:39-43"
   V2424 = "ACC HOUSE VALUE    46:44"
   V2425 = "REM MORT PRINC  46:45-49"
   V2426 = "ACC REM MORT PRINC 46:50"
   V2427 = "ANNUAL MORT PAY 46:51-54"
   V2428 = "ACC MORT PAY       46:55"
   V2429 = "ANNUAL RENT     46:56-59"
   V2430 = "ACC ANNUAL RENT    46:60"
   V2431 = "ANNUAL RENT VAL 46:61-64"
   V2432 = "ACC ANNUAL RENT VAL46:65"
   V2433 = "CODE:WK FOR HOUSE  46:66"
   V2434 = "ANNUAL UTILITIES46:67-70"
   V2435 = "ACC UTILITIES      46:71"
   V2436 = "$  SAVED ON A& R  46:72-75"
   V2437 = "ACC $  SAVED A& R    46:76"
   V2438 = "HOME PROD HRS   46:77-80"
   V2439 = "HRS HEAD WORKED 47:10-13"
   V2440 = "ACC HRS HD WKD     47:14"
   V2441 = "HRS HEAD ILL    47:15-18"
   V2442 = "ACC HRS HD ILL     47:19"
   V2443 = "HRS HEAD UNEMP  47:20-23"
   V2444 = "ACC HRS HEAD UNEMP 47:24"
   V2445 = "$  HEAD TRVL WK  47:25-28"
   V2446 = "ACC $  HEAD TRVL WK 47:29"
   V2447 = "HRS HD TRVL WK  47:30-32"
   V2448 = "ACC HRS HEAD TR WK 47:33"
   V2449 = "HRS WIFE WORKED 47:34-37"
   V2450 = "ACC HRS WIFE WK    47:38"
   V2451 = "$  WIFE TRVL WK  47:39-42"
   V2452 = "ACC $  WIFE TRVL WK 47:43"
   V2453 = "HRS WF TRVL WK  47:44-46"
   V2454 = "ACC HRS WF TRVL WK 47:47"
   V2455 = "HRS HSWK 1ST    47:48-51"
   V2456 = "ACC HRS HSWK 1ST   47:52"
   V2457 = "HRS HSWK HUSBAND47:53-56"
   V2458 = "ACC HSWK HUSBAND   47:57"
   V2459 = "HRS HSWK OTHER  47:58-61"
   V2460 = "ACC HRS HSWK OTHER 47:62"
   V2461 = "HRS HSWK NONFU  47:63-66"
   V2462 = "ACC HRS HSWK NONFU 47:67"
   V2463 = "$  HSWK NONFU    47:68-71"
   V2464 = "ACC $  HSWK NONFU   47:72"
   V2465 = "COST CHILD CARE 47:73-76"
   V2466 = "ACC COST CHILD CARE47:77"
   V2467 = "# MAJOR ADULTS     47:78"
   V2468 = "# IN FU         48:10-11"
   V2469 = "# REQUIRED ROOMS   48:12"
   V2470 = "FU WKLY FOOD STD48:13-17"
   V2471 = "ANNUAL NEED STD 48:18-22"
   V2472 = "$  ANNUAL ALCOHOL48:23-26"
   V2473 = "ACC $  ANA ALCOHOL  48:27"
   V2474 = "$  ANNUAL CIGS   48:28-30"
   V2475 = "ACC $  ANN CIGARETTE48:31"
   V2476 = "$  FOOD USED HOME48:32-35"
   V2477 = "ACC $  FOOD HOME    48:36"
   V2478 = "$  SAVD FD STMP  48:37-40"
   V2479 = "ACC $  SAVD FD STMP 48:41"
   V2480 = "$  EATING OUT    48:42-45"
   V2481 = "ACC $  EATING OUT   48:46"
   V2482 = "STMP SUBSIDY INCL? 48:47"
   V2483 = "$  MEALS WRK/SCH 48:48-51"
   V2484 = "ACC $  MEALS W/S    48:52"
   V2485 = "$  SAVD GROW FOOD48:53-56"
   V2486 = "ACC $  SAVD GROW FD 48:57"
   V2487 = "$  SAVD WRK/SCH  48:58-61"
   V2488 = "$  ACC SAVD WRK/SCH 48:62"
   V2489 = "$  SAVD OTHER FD 48:63-66"
   V2490 = "ACC $  SAVD OTHER FD48:67"
   V2491 = "BKT LABOR FARM Y   49:10"
   V2492 = "BKT LABOR BUS.Y    49:11"
   V2493 = "HEAD WAGES      49:12-16"
   V2494 = "ACC HEAD WAGES     49:17"
   V2495 = "BKT BONUS,OVERTIME 49:18"
   V2496 = "BKT PROF,PRACT,TRD 49:19"
   V2497 = "BKT LABOR ROOMER Y 49:20"
   V2498 = "LABOR INC HEAD  49:21-25"
   V2499 = "ACC LABOR Y HEAD   49:26"
   V2500 = "LABOR INC WIFE  49:27-31"
   V2501 = "ACC LABOR Y WIFE   49:32"
   V2502 = "BKT ASSET FARM Y   49:33"
   V2503 = "BKT ASSET BUS.Y    49:34"
   V2504 = "BKT ASSET ROOMER Y 49:35"
   V2505 = "BKT RENT,DIV,INT   49:36"
   V2506 = "BKT WIFE ASSET Y   49:37"
   V2507 = "H+W TAXABLE INC 49:38-42"
   V2508 = "ACC H+W TAXBL INC  49:43"
   V2509 = "$  CNTRB OUT FU  49:44-48"
   V2510 = "# DEPENDENTS H& W   49:49"
   V2511 = "TAXES OF H& W    49:50-54"
   V2512 = "ADC, AFDC H& W   50:10-14"
   V2513 = "ACC ADC H& W        50:15"
   V2514 = "OTHER WELFARE   50:16-20"
   V2515 = "SOCIAL SECURITY 50:21-25"
   V2516 = "OTHER RETIREMENT50:26-30"
   V2517 = "UNEMP,WRK.COMP  50:31-35"
   V2518 = "ALIMONY,CHLD SPT50:36-40"
   V2519 = "BKT HELP FROM REL. 50:41"
   V2520 = "BKT ANYTHING ELSE  50:42"
   V2521 = "BKT WIFE TRANSFERS 50:43"
   V2522 = "ACC MISC TRANSFERS 50:44"
   V2523 = "TRANSFER Y H& W  50:45-49"
   V2524 = "HOURS WRK OTHERS50:50-53"
   V2525 = "TAXBL INC OTHERS50:54-58"
   V2526 = "ACC TAXBL Y OTHERS 50:59"
   V2527 = "OTHERS TAXES    50:60-64"
   V2528 = "OTHERS TRANSFER 50:65-69"
   V2529 = "ACC OTHERS TRANS Y 50:70"
   V2530 = "# OTHER Y RECEIVERS50:71"
   V2531 = "# OTHER W LABOR INC50:72"
   V2532 = "LABOR UNION DUES50:73-76"
   V2533 = "1968 INTERVIEW# 51:10-13"
   V2534 = "1969 INTERVIEW# 51:14-17"
   V2535 = "1970 INTERVIEW# 51:18-21"
   V2536 = "1971 INTERVIEW# 51:22-25"
   V2537 = "IWERS SOC SEC # 51:26-34"
   V2538 = "IWERS INT #     51:35-36"
   V2539 = "DATE OF IW         51:37"
   V2540 = "LENGTH OF IW    51:38-40"
   V2541 = "# IN FU         51:41-42"
   V2542 = "AGE OF HEAD     51:43-44"
   V2543 = "SEX OF HEAD        51:45"
   V2544 = "AGE OF WIFE     51:46-47"
   V2545 = "# CHILDREN IN FU51:48-49"
   V2546 = "AGE YNGST CHILD 51:50-51"
   V2547 = "ANY CHILD UNDER 25 51:52"
   V2548 = "# CHLDRN IN SCHOOL 51:53"
   V2549 = "EDUC EXPT CHILDREN 51:54"
   V2550 = "LAST PTA MTG ATTND 51:55"
   V2551 = "ANY CHILD STOP SCH 51:56"
   V2552 = "PUBLIC TRANSP AVAIL51:57"
   V2553 = "PUB TRANSP GOOD    51:58"
   V2554 = "OWN CAR OR TRUCK   51:59"
   V2555 = "DIFFIC FROM NO CAR 51:60"
   V2556 = "WHAT DIFFIC NO CAR 51:61"
   V2557 = "NR CARS OWNED      51:62"
   V2558 = "YR OF NEWEST CAR51:63-64"
   V2559 = "CONDIT NEWEST CAR  51:65"
   V2560 = "ALL CARS INSURED?  51:66"
   V2561 = "CAR HAVE SEAT BELTS51:67"
   V2562 = "SEAT BELTS FASTND  51:68"
   V2563 = "DID OWN REPAIR     51:69"
   V2564 = "KIND OF CAR REPAIR 51:70"
   V2565 = "ACTUAL # ROOMS     51:71"
   V2566 = "OWN OR RENT?       51:72"
   V2567 = "MORTGAGE?          51:73"
   V2568 = "PYMTS INCL TAXES?  51:74"
   V2569 = "PYMTS INC INS PREM?51:75"
   V2570 = "SECOND MORTGAGE?   51:76"
   V2571 = "WHY FREE HOUSING?  51:77"
   V2572 = "WORK DONE ON HOUSE 52:10"
   V2573 = "WHAT A& R DONE?     52:11"
   V2574 = "WHO DID A& R?       52:12"
   V2575 = "NR NEIGHBORS KNOWN 52:13"
   V2576 = "RELATIVES NEAR     52:14"
   V2577 = "MOVED SINCE SPRING 52:15"
   V2578 = "WHY MOVED?         52:16"
   V2579 = "MIGHT MOVE?        52:17"
   V2580 = "WHY MIGHT MOVE     52:18"
   V2581 = "EMPLOYMENT STATUS  52:19"
   V2582 = "OCCUPATION-HEAD(E) 52:20"
   V2583 = "INDUS-HEADS OCC 52:21-22"
   V2584 = "SELF EMPLOYED HEAD 52:23"
   V2585 = "HOW LONG HAD JOB   52:24"
   V2586 = "HAPPENED PREV JOB  52:25"
   V2587 = "JOB PAY MORE NOW   52:26"
   V2588 = "PRESENT JOB BETTER 52:27"
   V2589 = "WHY JOB BETTER?    52:28"
   V2590 = "TOOK VACATION 71(E)52:29"
   V2591 = "WKS VAC 70(E)   52:30-31"
   V2592 = "MISS WORK SICK(E)  52:32"
   V2593 = "WKS SICK (E)    52:33-34"
   V2594 = "UNEMPLYD OR STRIKE 52:35"
   V2595 = "WKS UNEMPLYD(E) 52:36-37"
   V2596 = "WKS WORK HEAD(E)52:38-39"
   V2597 = "HRS/WK WRK HD(E)52:40-41"
   V2598 = "EXTRA HRS PAY(E)   52:42"
   V2599 = "OTIME HRLY WAGE 52:43-45"
   V2600 = "WTR REG WAGE       52:46"
   V2601 = "REG HRLY WAGE(E)52:47-49"
   V2602 = "EXTRA JOBS? (E)    52:50"
   V2603 = "OCCUP EXTRA JOB(E) 52:51"
   V2604 = "MORE THAN 2 JOBS(E)52:52"
   V2605 = "PAY/HR XTRA WRK 52:53-55"
   V2606 = "WEEKS EXTRA JOB 52:56-57"
   V2607 = "HRS/WK XTRA JOB 52:58-59"
   V2608 = "MORE WRK AVAILABLE 52:60"
   V2609 = "WANTED MORE WORK   52:61"
   V2610 = "COULD WORK LESS    52:62"
   V2611 = "PREFRD LESS WORK   52:63"
   V2612 = "MILES TO WORK   52:64-65"
   V2613 = "DRIVE TO WORK OR?  52:66"
   V2614 = "LATE GETTNG TO WORK52:67"
   V2615 = "HOW OFTEN LATE     52:68"
   V2616 = "SKIP WORK NOT SICK 52:69"
   V2617 = "HOW OFTN SKIP WORK 52:70"
   V2618 = "MAY GET NEW JOB(E) 52:71"
   V2619 = "KIND OF NEW JOB(E) 52:72"
   V2620 = "POSSIBLE WAGE(E)52:73-75"
   V2621 = "TRNING NEW JOB(E)  52:76"
   V2622 = "DOING ABT NEW JOB? 52:77"
   V2623 = "WHAT DONE-NEW JOB? 52:78"
   V2624 = "WILLING TO MOVE JOB53:11"
   V2625 = "PAY/HR REQD MOVE53:12-14"
   V2626 = "WHY WONT MOVE JOB  53:15"
   V2627 = "JOB ENJOYABLE?     53:16"
   V2628 = "WHY JOB ENJOY(1)?  53:17"
   V2629 = "WHY JOB ENJOY(2)?  53:18"
   V2630_1 = "2 REAS ENJY JOB 53:17-18 RESP 1"
   V2630_2 = "2 REAS ENJY JOB 53:17-18 RESP 2"
   V2631 = "OCCUP HEAD(U)      53:19"
   V2632 = "PAY/HR SOUGHT(U)53:20-22"
   V2633 = "TRAINING REQD(U)   53:23"
   V2634 = "HOW FINDING JOB(U) 53:24"
   V2635 = "# PLACES LOOKED(U) 53:25"
   V2636 = "OCCUP-PREV JOB(U)  53:26"
   V2637 = "IND PREV JOB(U) 53:27-28"
   V2638 = "HAPPEND PREV JOB(U)53:29"
   V2639 = "WKS WKD-71 (U)  53:30-31"
   V2640 = "HRS/WK WRK-71(U)53:32-33"
   V2641 = "WKS SICK-71 (U) 53:34-35"
   V2642 = "WKS UNEMPLYD(U) 53:36-37"
   V2643 = "MILES TO WORK(U)53:38-39"
   V2644 = "DRIVE TO WRK OR?(U)53:40"
   V2645 = "LATE TO WORK (U)   53:41"
   V2646 = "HOW OFTEN LATE (U) 53:42"
   V2647 = "SKP WRK-NOT SICK(U)53:43"
   V2648 = "HOW OFTN SKP WK(U) 53:44"
   V2649 = "JOBS NOT WRTH IT(U)53:45"
   V2650 = "PAY/HR REJECT(U)53:46-48"
   V2651 = "WILLNG MOVE JOB(U) 53:49"
   V2652 = "PAY/HR RQD-MV(U)53:50-52"
   V2653 = "WHY NOT MOVE JOB(U)53:53"
   V2654 = "WTR WKD-71 (R)     53:54"
   V2655 = "THINKING ABT WK(R) 53:55"
   V2656 = "OCCUPATION HEAD(R) 53:56"
   V2657 = "INDUS-HDS OCC(R)53:57-58"
   V2658 = "WKS WRKD-HD (R) 53:59-60"
   V2659 = "HRS/WK WKD HD(R)53:61-62"
   V2660 = "NEW JOB NEXT YR?   53:63"
   V2661 = "KIND OF NEW JOB(R) 53:64"
   V2662 = "POSSIBLE WAGE(R)53:65-67"
   V2663 = "TRNING NEW JOB?(R) 53:68"
   V2664 = "DOING ABT NU JOB(R)53:69"
   V2665 = "# PLACES APPLIED(R)53:70"
   V2666 = "JOBS NOT WRTH IT(R)53:71"
   V2667 = "PAY/HR REJECT(R)53:72-74"
   V2668 = "THINKNG WRK FUT(R) 53:75"
   V2669 = "WRK DEPENDS ON(R)  53:76"
   V2670 = "MARITAL STATUS     54:10"
   V2671 = "DID WIFE WORK?     54:11"
   V2672 = "OCCUPATION-WIFE    54:12"
   V2673 = "INDUS WIFES OCC 54:13-14"
   V2674 = "WEEKS WIFE WRKD 54:15-16"
   V2675 = "HRS/WK WIFE WKD 54:17-18"
   V2676 = "WIFE-MORE WK AVAIL 54:19"
   V2677 = "WIFE-WANT MORE WK? 54:20"
   V2678 = "WIFE ABLE FIND JOB 54:21"
   V2679 = "WIFE WRK IN FUTURE 54:22"
   V2680 = "WIFE WK DEPND ON(1)54:23"
   V2681 = "WIFE WK DEPND ON(2)54:24"
   V2682_1 = "2THNG WF WK DPND54:23-24 RESP 1"
   V2682_2 = "2THNG WF WK DPND54:23-24 RESP 2"
   V2683 = "EXPECT CHILDREN?   54:26"
   V2684 = "LIMIT # CHILDREN?  54:27"
   V2685 = "WHEN EXPECT CHILD  54:28"
   V2686 = "HOW MANY CHLDRN TOT54:29"
   V2687 = "EDUCATION-WIFE     54:30"
   V2688 = "WHO DOES HOUSEWRK? 54:31"
   V2689 = "HRS/WK 1ST HSWRK54:32-33"
   V2690 = "OTHERS DO HSWRK?   54:34"
   V2691 = "HELP FROM OUTSIDE? 54:35"
   V2692 = "PAY FOR HELP?      54:36"
   V2693 = "HOW OFTN EAT TGTHR 54:37"
   V2694 = "TOT FARM RECEIPTS  54:39"
   V2695 = "OWN A BUSINESS?    54:40"
   V2696 = "BUS INCORPORATED?  54:41"
   V2697 = "ANY CHANGES IN $ WEL54:43"
   V2698 = "WHAT ARE CHANGES   54:44"
   V2699 = "HOW AFFECTED YOU?  54:45"
   V2700 = "$  EARN-CUT WELF?54:46-48"
   V2701 = "CUT WLFRE/$ 10 MORE 54:49"
   V2702 = "INSURANCE,INHERIT  54:50"
   V2703 = "HOW MUCH INS/INH?  54:51"
   V2704 = "71 Y HIGHER OR 70  54:52"
   V2705 = "WHY INCOME DIFF    54:53"
   V2706 = "UNUSUAL EXPENSES   54:54"
   V2707 = "WHY EXPENSES UNUSL 54:55"
   V2708 = "ANY OUTSIDE DEPS?  54:56"
   V2709 = "# OUTSIDE DEPENDTS 54:57"
   V2710 = "# DEP >HALF SUPPORT54:58"
   V2711 = "WOULD HELP RELATIVE54:59"
   V2712 = "ANY SAVINGS?       54:60"
   V2713 = "2 MONTHS Y SAVED   54:61"
   V2714 = "2 MO Y SAVD IN 5YRS54:62"
   V2715 = "MEDICAL INS.-HEAD  54:63"
   V2716 = "ENTIRE FAMILY INS. 54:64"
   V2717 = "FREE MEDICAL CARE? 54:65"
   V2718 = "DISAB LIM KIND WRK 54:66"
   V2719 = "DISAD LIM AMT WRK  54:67"
   V2720 = "HOW LONG LIMITED   54:68"
   V2721 = "HEALTH IMPROVING   54:69"
   V2722 = "OTHERS DISABLED?   55:10"
   V2723 = "WHO ELSE DISABLED? 55:11"
   V2724 = "AGE OF DISABLED 55:12-13"
   V2725 = "WHY OTHER DISABLED 55:14"
   V2726 = "OTHER EXTRA CARE   55:15"
   V2727 = "WHO REQ EXTRA CARE 55:16"
   V2728 = "AGE REQ XTR CARE55:17-18"
   V2729 = "WHY REQ XTRA CARE  55:19"
   V2730 = "SEE ONLY AT NIGHT  55:20"
   V2731 = "NOT EVERY CLOUD    55:21"
   V2732 = "IN THE SPRING      55:22"
   V2733 = "AN APPLE A DAY     55:23"
   V2734 = "THE RAGGED COLT    55:24"
   V2735 = "CHILD GIVEN WISH   55:25"
   V2736 = "MAKE GOOD DAMAGES  55:26"
   V2737 = "FALSE FACTS        55:27"
   V2738 = "GUILTY ESCAPE      55:28"
   V2739 = "WINDS AND WAVES    55:29"
   V2740 = "VANQUISHED NEVER   55:30"
   V2741 = "THINK LONG         55:31"
   V2742 = "COWARD THREATENS   55:32"
   V2743 = "SURE LIFE WORK OUT 55:33"
   V2744 = "PLAN OR DAY-DAY    55:34"
   V2745 = "CARRY OUT PLANS OR 55:35"
   V2746 = "FINSH THINGS OR NOT55:36"
   V2747 = "CONTROL OVER LIFE? 55:37"
   V2748 = "RATHR SPEND OR SAVE55:38"
   V2749 = "SATISFIED WITH SELF55:39"
   V2750 = "PAST RECORD BAD?   55:40"
   V2751 = "GET ANGRY EASILY   55:41"
   V2752 = "MATTER OTHRS THINK 55:42"
   V2753 = "TRUST MOST OTHERS? 55:43"
   V2754 = "FIGR WAYS MOR MONEY55:44"
   V2755 = "THINK ABOUT FUTURE 55:45"
   V2756 = "AV MAN GETTNG BETTR55:46"
   V2757 = "LOT GOOD DONT DSRV 55:47"
   V2758 = "RATHR JOB LIKE     55:48"
   V2759 = "WHY QUIT? DIFF/CHAL55:49"
   V2760 = "CHLD POPULR OR LEAD55:50"
   V2761 = "CHLD-DO WHAT EXPECT55:51"
   V2762 = "MORE FRIENS OR BETR55:52"
   V2763 = "MORE ATTN OR BETTR 55:53"
   V2764 = "JOB-THINK OR PEOPLE55:54"
   V2765 = "JOB-THINK FOR SELF 55:55"
   V2766 = "OPINION IMP OR LIKE55:56"
   V2767 = "LIKE OR DO ANYTHNG 55:57"
   V2768 = "FUN OR ADVICE      55:58"
   V2769 = "TEST BEHAVIOR      55:59"
   V2770 = "HEART BEAT-TEST    55:60"
   V2771 = "WORRY ABT FAILING  55:61"
   V2772 = "PERSPIRE DURNG TEST55:62"
   V2773 = "DONE WELL-KNOW MORE55:63"
   V2774 = "DURING WELL-FEEL GD55:64"
   V2775 = "WHAT DO SPARE TIME 55:65"
   V2776 = "2ND USE SPARE TIME 55:66"
   V2777_1 = "2 USES SPARE TIM55:65-66 RESP 1"
   V2777_2 = "2 USES SPARE TIM55:65-66 RESP 2"
   V2778 = "# THINGS DONE SP-T 55:67"
   V2779 = "COURSES OR LESSONS 55:68"
   V2780 = "WHAT COURSES       55:69"
   V2781 = "HRS/WK TELEVISION  55:70"
   V2782 = "HOW OFTN NEWSPAPER 55:71"
   V2783 = "HOW OFTN CHURCH    55:72"
   V2784 = "HOW OFTN CLUBS     55:73"
   V2785 = "HOW OFTN BAR/TAVRN 55:74"
   V2786 = "LAST TIME VOTED    55:75"
   V2787 = "UNION MEMBER       55:76"
   V2788 = "1ST IMPRES LST 5YRS55:77"
   V2789 = "2ND IMPRES LST 5YRS55:78"
   V2790_1 = "TWO IMPRES-5YRS 55:77-78 RESP 1"
   V2790_2 = "TWO IMPRES-5YRS 55:77-78 RESP 2"
   V2791 = "SAME HEAD?         56:10"
   V2792 = "ST DAD GREW UP  56:11-12"
   V2793 = "CNTY DAD GREW UP56:13-15"
   V2794 = "ST MOM GREW UP  56:16-17"
   V2795 = "CNTY MOM GREW UP56:18-20"
   V2796 = "FATHERS OCCUPATION 56:21"
   V2797 = "HEADS FIRST JOB    56:22"
   V2798 = "HEAD IN SAME OCCUP?56:23"
   V2799 = "AGE OLDST CHILD 56:24-25"
   V2800 = "AGE 2ND OLDEST  56:26-27"
   V2801 = "AGE 3RD OLDEST  56:28-29"
   V2802 = "# CHILDREN HEAD 56:30-31"
   V2803 = "# CHILD HEAD BY 25 56:32"
   V2804 = "# SIBLINGS HEAD    56:33"
   V2805 = "ANY LIVING BRTHR-HD56:34"
   V2806 = "AGE OLDST BRTHR 56:35-36"
   V2807 = "EDUC OLDST BRTHR   56:37"
   V2808 = "OLDST BRTH WELLOFF 56:38"
   V2809 = "HD-ANY LIVNG SISTER56:39"
   V2810 = "AGE OLDST SISTER56:40-41"
   V2811 = "EDUC OLDST SISTER  56:42"
   V2812 = "OLDST SISTR WELLOFF56:43"
   V2813 = "RELIGION           56:44"
   V2814 = "HEAD GREW UP FARM  56:45"
   V2815 = "STATE HD GREW UP56:46-47"
   V2816 = "CNTY HD GREW UP 56:48-50"
   V2817 = "# REGIONS LIVED IN 56:51"
   V2818 = "# STATES HD LVD IN 56:52"
   V2819 = "EVER MOVED FOR JOB 56:53"
   V2820 = "EVER REFUSED MOVE? 56:54"
   V2821 = "HEADS PARENTS POOR 56:55"
   V2822 = "HDS FATHERS EDUC   56:56"
   V2823 = "EDUCATION OF HEAD  56:57"
   V2824 = "OTHR TRAINING HEAD 56:58"
   V2825 = "HEAD A VETERAN?    56:59"
   V2826 = "WHO PRESENT?       56:60"
   V2827 = "WHO RESPDNT(REL)   56:61"
   V2828 = "RACE               56:62"
   V2829 = "# OF CALLS         56:63"
   V2830 = "READING MTL VISIBLE56:64"
   V2831 = "HOW CLEAN DU?      56:65"
   V2832 = "LANGUAGE PROBLEMS  56:66"
   V2833 = "HEAD DISFIGURED    56:67"
   V2834 = "IN CITY LMT(5000+) 56:68"
   V2835 = "NEAREST SMSA    56:69-71"
   V2836 = "DIST TO CNTR SMSA  56:72"
   V2837 = "TYPE OF STRUCTURE  56:73"
   V2838 = "NEIGHBORHOOD-LOWST 56:74"
   V2839 = "NEIGHBORHOOD-HGHST 56:75"
   V2840 = "DU IN PUBL HOUSING 56:76"
   V2841 = "INSIDE TOILET?     56:77"
   V2842 = "RUNNING WATER?     56:78"
   V2843 = "DU NEED EXTEN REPR 56:79"
   V2844 = "FINANL FRM OF REF  55:79"
   V2845 = "QLTY OF LFE FRM REF55:80"
   V2846 = "YRLY PROPERTY TXS 2V446"
   V2847 = "ANN MORT PYMT(REV) 2V447"
   V2848 = "IMPUTED RENT       2V448"
   V2849 = "HOUSE VALUE BKT    2V449"
   V2850 = "LEISURE NET TRAVEL 2V450"
   V2851 = "LEISURE COMP 68    2V451"
   V2852 = "TOT FU MON INC     2V452"
   V2853 = "BKT TOT FU MON INC 2V453"
   V2854 = "BKT LABOR INC HEAD 2V454"
   V2855 = "BKT LABOR INC WIFE 2V455"
   V2856 = "BKT H+W TAXABLE Y  2V456"
   V2857 = "BKT OTHERS TAXBL Y 2V457"
   V2858 = "BKT ADC,AFDC HEAD  2V458"
   V2859 = "BKT OTHER WELFARE  2V459"
   V2860 = "BKT SOCIAL SEC     2V460"
   V2861 = "BKT OTHER RETIREMNT V461"
   V2862 = "BKT UNEMP WRK COMP 2V462"
   V2863 = "BKT ALMNY CHLD SUP 2V463"
   V2864 = "BKT TOT TRNSFRS H+W2V464"
   V2865 = "MISC TRANSFERS H+W 2V465"
   V2866 = "BKT MISC TRNFR H+W 2V466"
   V2867 = "BKT OTHRS TRNSFR Y 2V467"
   V2868 = "MONEY Y/NEEDS      2V468"
   V2869 = "BKT MONEY Y/NEEDS 2V469"
   V2870 = "W-O MONEY INC      2V470"
   V2871 = "BKT W-O MONEY INC  2V471"
   V2872 = "FRE HELP FRM OTHRS 2V472"
   V2873 = "TOTAL REAL Y       2V473"
   V2874 = "BKT TOTAL REAL Y   2V474"
   V2875 = "TOTAL COST OF INC  2V475"
   V2876 = "REAL NET INC       2V476"
   V2877 = "BKT REAL NET INC   2V477"
   V2878 = "REAL NET Y/NEEDS   2V478"
   V2879 = "BKT RL NET Y/NEEDS 2V479"
   V2880 = "W-O NET REAL       2V480"
   V2881 = "BKT W-O NET REAL   2V481"
   V2882 = "COST OF HOUSING    2V482"
   V2883 = "BKT COST OF HOUSNG 2V483"
   V2884 = "REAL NET (2)Y      2V484"
   V2885 = "BKT REAL NET (2)Y  2V485"
   V2886 = "NET (2) Y/NEEDS    2V486"
   V2887 = "BKT NET (2)Y/NEEDS 2V487"
   V2888 = "W-O NET (2)Y       2V488"
   V2889 = "BKT W-O NET (2)Y   2V489"
   V2890 = "NET Y-HOUSING      2V490"
   V2891 = "BKT NET Y-HOUSING  2V491"
   V2892 = "ANNUAL FOOD STD    2V492"
   V2893 = "NET Y-HSNG/FD ND   2V493"
   V2894 = "BKT Y-HSNG/FD ND   2V494"
   V2895 = "W-O NET Y-HSNG     2V495"
   V2896 = "BKT W-O NET Y-HSNG 2V496"
   V2897 = "W-O NET (2) Y-HSNG 2V497"
   V2898 = "TOTAL FOOD CONS    2V498"
   V2899 = "BKT TOT FD CONS    2V499"
   V2900 = "FOOD CONS/FD ND    2V500"
   V2901 = "BKT FD CONS/FD ND  2V501"
   V2902 = "TOTAL FAMILY WORK  2V502"
   V2903 = "BKT TOT FAM WORK   2V503"
   V2904 = "FAM WORK INCL TRAV 2V504"
   V2905 = "BKT WORK INCL TRAV 2V505"
   V2906 = "HEADS AVG HRLY ERN 2V506"
   V2907 = "BKT HD AVG HR EARN 2V507"
   V2908 = "WIFE AVG HRLY EARN 2V508"
   V2909 = "BKT WF AVG HR EARN 2V509"
   V2910 = "RESERVE FUNDS      2V510"
   V2911 = "CURRENT REGION     2V511"
   V2912 = "REGN HD GREW UP    2V512"
   V2913 = "REGN DAD GREW UP   2V513"
   V2914 = "REGN MOM GREW UP   2V514"
   V2915 = "GEOGRAPHIC MOBILTY 2V515"
   V2916 = "ACCURACY MONEY INC 2V516"
   V2917 = "ACCURACY HOURS     2V517"
   V2918 = "ACCURACY REAL INC  2V518"
   V2919 = "# MINOR ASSIGNMENT 2V519"
   V2920 = "#MAJOR ASSIGNMENT 2V520"
   V2921 = "VALUE PER ROOM     2V521"
   V2922 = "BKT VALUE PER ROOM 2V522"
   V2923 = "BKT CAR VALUE      2V523"
   V2924 = "BKT OV-TIM HR WAGE 2V524"
   V2925 = "BKT REG HRLY WAGE  2V525"
   V2926 = "BKT PAY 2ND JOB    2V526"
   V2927 = "ACTUAL-REQD ROOMS  2V527"
   V2928 = "PERSONS PER ROOM   2V528"
   V2929 = "BKT PERSONS/ROOM   2V529"
   V2930 = "NUMBER OF ADULTS   2V530"
   V2931 = "HOUSEWORK H+W      2V531"
   V2932 = "NON-LEISURE COMP   2V532"
   V2933 = "ONE DIGIT FAM SIZE 2V533"
   V2934 = "BKT AGE OF HEAD    2V534"
   V2935 = "BKT AGE OF WIFE    2V535"
   V2936 = "HOME PROD HRS(REV) 2V536"
   V2937 = "TOTAL NONLEISR HRS 2V537"
   V2938 = "HOUSING NBHD QULTY 2V538"
   V2939 = "EFF/PLAN COMP 70 2V539"
   V2940 = "TRUST OR HOSTILITY 2V540"
   V2941 = "SCRAMBLE FOR WORK  2V541"
   V2942 = "ASPIRATION AMBITIN 2V542"
   V2943 = "REAL EARNING ACTS  2V543"
   V2944 = "ECONOMISING 1972 2V544"
   V2945 = "RISK AVOIDANCE     2V545"
   V2946 = "HORZ PROX COMP 70 2V546"
   V2947 = "CONNECTEDNESS      2V547"
   V2948 = "MONEY EARNING ACTS 2V548"
   V2949 = "IQ SCORE           2V549"
   V2950 = "FEELINGS           2V550"
   V2951 = "DEC TOT FAM IND(V452)"
   V2952 = "DEC FAM INC/NEEDS(V468)"
   V2953 = "DEC W-O MONEY(V470)"
   V2954 = "DEC NET REAL INC(V476)"
   V2955 = "DEC NET RL INC/NDS(V478)"
   V2956 = "DEC W-O NET REAL(V480)8)"
   V2957 = "DEC NET INC-HSNG(V490)"
   V2958 = "DEC NET INC-HSG/ND(V493)"
   V2959 = "DEC WO-NET INC-HSG(V495)"
   V2960 = "SHORTAGE MALE LABOR"
   V2961 = "FEMALE MARKET"
   V2962 = "NONWHITE MARKET"
   V2963 = "MALE WAGE"
   V2964 = "FEMALE WAGE"
   V2965 = "UNEMPLOYMENT RATE"
   V2966 = "FAKE 1972 ID"
   V2967 = "FAKE 1968 ID"
   V2968 = "1972 WEIGHTS"
   V2969 = "SPLIT SAMPLE"
   V2970 = "5YR AVG TOT MONEY INC"
   V2971 = "BKT 5YR AVG TOT FU MNY I"
   V2972 = "5YR FAM COMP CHANGE"
   V2973 = "5YR CHANGE IN JOBS"
   V2974 = "5YR CHANGE IN RESIDENCE"
   V2975 = "# YR-YR CHGS:COUNTY"
   V2976 = "# YR-YR CHGS:STATE"
   V2977 = "# YR-YR CHGS:REGION"
   V2978 = "UNIQUE LINK TO 1968"
   V2979 = "HOUSEHOLD ID # 72"
   V2980 = "FU PRIMACY WITHIN HU";

* USER-DEFINED MISSING VALUE RECODE TO SAS SYSMIS;

IF V2509 GE 99999 THEN V2509=.;
IF V2539 GE 9 THEN V2539=.;
IF V2540 GE 999 THEN V2540=.;
IF V2547 GE 9 THEN V2547=.;
IF V2548 GE 9 THEN V2548=.;
IF V2549 GE 9 THEN V2549=.;
IF V2550 GE 9 THEN V2550=.;
IF V2551 GE 9 THEN V2551=.;
IF V2552 GE 9 THEN V2552=.;
IF V2553 GE 9 THEN V2553=.;
IF V2554 GE 9 THEN V2554=.;
IF V2555 GE 9 THEN V2555=.;
IF V2556 GE 9 THEN V2556=.;
IF V2557 GE 9 THEN V2557=.;
IF V2558 GE 99 THEN V2558=.;
IF V2559 GE 9 THEN V2559=.;
IF V2560 GE 9 THEN V2560=.;
IF V2561 GE 9 THEN V2561=.;
IF V2562 GE 9 THEN V2562=.;
IF V2563 GE 9 THEN V2563=.;
IF V2564 GE 9 THEN V2564=.;
IF V2565 GE 9 THEN V2565=.;
IF V2567 GE 9 THEN V2567=.;
IF V2568 GE 9 THEN V2568=.;
IF V2569 GE 9 THEN V2569=.;
IF V2570 GE 9 THEN V2570=.;
IF V2571 GE 9 THEN V2571=.;
IF V2572 GE 9 THEN V2572=.;
IF V2573 GE 9 THEN V2573=.;
IF V2574 GE 9 THEN V2574=.;
IF V2575 GE 9 THEN V2575=.;
IF V2576 GE 9 THEN V2576=.;
IF V2577 GE 9 THEN V2577=.;
IF V2578 GE 9 THEN V2578=.;
IF V2579 GE 9 THEN V2579=.;
IF V2580 GE 9 THEN V2580=.;
IF V2584 GE 9 THEN V2584=.;
IF V2585 GE 9 THEN V2585=.;
IF V2586 GE 9 THEN V2586=.;
IF V2587 GE 9 THEN V2587=.;
IF V2588 GE 9 THEN V2588=.;
IF V2589 GE 9 THEN V2589=.;
IF V2590 GE 9 THEN V2590=.;
IF V2591 GE 99 THEN V2591=.;
IF V2592 GE 9 THEN V2592=.;
IF V2593 GE 99 THEN V2593=.;
IF V2594 GE 9 THEN V2594=.;
IF V2595 GE 99 THEN V2595=.;
IF V2596 GE 99 THEN V2596=.;
IF V2597 GE 99 THEN V2597=.;
IF V2598 GE 9 THEN V2598=.;
IF V2599 GE 999 THEN V2599=.;
IF V2600 GE 9 THEN V2600=.;
IF V2601 GE 999 THEN V2601=.;
IF V2602 GE 9 THEN V2602=.;
IF V2603 GE 9 THEN V2603=.;
IF V2604 GE 9 THEN V2604=.;
IF V2605 GE 999 THEN V2605=.;
IF V2606 GE 99 THEN V2606=.;
IF V2607 GE 99 THEN V2607=.;
IF V2608 GE 9 THEN V2608=.;
IF V2609 GE 9 THEN V2609=.;
IF V2610 GE 9 THEN V2610=.;
IF V2611 GE 9 THEN V2611=.;
IF V2612 GE 99 THEN V2612=.;
IF V2613 GE 9 THEN V2613=.;
IF V2614 GE 9 THEN V2614=.;
IF V2615 GE 9 THEN V2615=.;
IF V2616 GE 9 THEN V2616=.;
IF V2617 GE 9 THEN V2617=.;
IF V2618 GE 9 THEN V2618=.;
IF V2619 GE 9 THEN V2619=.;
IF V2620 GE 999 THEN V2620=.;
IF V2621 GE 9 THEN V2621=.;
IF V2622 GE 9 THEN V2622=.;
IF V2623 GE 9 THEN V2623=.;
IF V2624 GE 9 THEN V2624=.;
IF V2625 GE 999 THEN V2625=.;
IF V2626 GE 9 THEN V2626=.;
IF V2627 GE 9 THEN V2627=.;
IF V2628 GE 9 THEN V2628=.;
IF V2629 GE 9 THEN V2629=.;
IF V2630_1 GE 9 THEN V2630_1=.;
IF V2630_2 GE 9 THEN V2630_2=.;
IF V2631 GE 9 THEN V2631=.;
IF V2632 GE 999 THEN V2632=.;
IF V2633 GE 9 THEN V2633=.;
IF V2634 GE 9 THEN V2634=.;
IF V2635 GE 9 THEN V2635=.;
IF V2636 GE 9 THEN V2636=.;
IF V2638 GE 9 THEN V2638=.;
IF V2639 GE 99 THEN V2639=.;
IF V2640 GE 99 THEN V2640=.;
IF V2641 GE 99 THEN V2641=.;
IF V2642 GE 99 THEN V2642=.;
IF V2643 GE 99 THEN V2643=.;
IF V2644 GE 9 THEN V2644=.;
IF V2645 GE 9 THEN V2645=.;
IF V2646 GE 9 THEN V2646=.;
IF V2647 GE 9 THEN V2647=.;
IF V2648 GE 9 THEN V2648=.;
IF V2649 GE 9 THEN V2649=.;
IF V2650 GE 999 THEN V2650=.;
IF V2651 GE 9 THEN V2651=.;
IF V2652 GE 999 THEN V2652=.;
IF V2653 GE 9 THEN V2653=.;
IF V2654 GE 9 THEN V2654=.;
IF V2655 GE 9 THEN V2655=.;
IF V2658 GE 99 THEN V2658=.;
IF V2659 GE 99 THEN V2659=.;
IF V2660 GE 9 THEN V2660=.;
IF V2661 GE 9 THEN V2661=.;
IF V2662 GE 999 THEN V2662=.;
IF V2663 GE 9 THEN V2663=.;
IF V2664 GE 9 THEN V2664=.;
IF V2665 GE 9 THEN V2665=.;
IF V2666 GE 9 THEN V2666=.;
IF V2667 GE 999 THEN V2667=.;
IF V2668 GE 9 THEN V2668=.;
IF V2669 GE 9 THEN V2669=.;
IF V2671 GE 9 THEN V2671=.;
IF V2674 GE 99 THEN V2674=.;
IF V2675 GE 99 THEN V2675=.;
IF V2676 GE 9 THEN V2676=.;
IF V2677 GE 9 THEN V2677=.;
IF V2678 GE 9 THEN V2678=.;
IF V2679 GE 9 THEN V2679=.;
IF V2680 GE 9 THEN V2680=.;
IF V2681 GE 9 THEN V2681=.;
IF V2682_1 GE 9 THEN V2682_1=.;
IF V2682_2 GE 9 THEN V2682_2=.;
IF V2683 GE 9 THEN V2683=.;
IF V2684 GE 9 THEN V2684=.;
IF V2685 GE 9 THEN V2685=.;
IF V2686 GE 9 THEN V2686=.;
IF V2687 GE 9 THEN V2687=.;
IF V2688 GE 9 THEN V2688=.;
IF V2689 GE 99 THEN V2689=.;
IF V2690 GE 9 THEN V2690=.;
IF V2691 GE 9 THEN V2691=.;
IF V2692 GE 9 THEN V2692=.;
IF V2693 GE 9 THEN V2693=.;
IF V2694 GE 9 THEN V2694=.;
IF V2695 GE 9 THEN V2695=.;
IF V2696 GE 9 THEN V2696=.;
IF V2697 GE 9 THEN V2697=.;
IF V2698 GE 9 THEN V2698=.;
IF V2699 GE 9 THEN V2699=.;
IF V2700 GE 999 THEN V2700=.;
IF V2701 GE 9 THEN V2701=.;
IF V2702 GE 9 THEN V2702=.;
IF V2703 GE 9 THEN V2703=.;
IF V2704 GE 9 THEN V2704=.;
IF V2705 GE 9 THEN V2705=.;
IF V2706 GE 9 THEN V2706=.;
IF V2707 GE 9 THEN V2707=.;
IF V2708 GE 9 THEN V2708=.;
IF V2709 GE 9 THEN V2709=.;
IF V2710 GE 9 THEN V2710=.;
IF V2711 GE 9 THEN V2711=.;
IF V2712 GE 9 THEN V2712=.;
IF V2713 GE 9 THEN V2713=.;
IF V2714 GE 9 THEN V2714=.;
IF V2715 GE 9 THEN V2715=.;
IF V2716 GE 9 THEN V2716=.;
IF V2717 GE 9 THEN V2717=.;
IF V2718 GE 9 THEN V2718=.;
IF V2719 GE 9 THEN V2719=.;
IF V2720 GE 9 THEN V2720=.;
IF V2721 GE 9 THEN V2721=.;
IF V2722 GE 9 THEN V2722=.;
IF V2723 GE 9 THEN V2723=.;
IF V2724 GE 99 THEN V2724=.;
IF V2725 GE 9 THEN V2725=.;
IF V2726 GE 9 THEN V2726=.;
IF V2727 GE 9 THEN V2727=.;
IF V2728 GE 99 THEN V2728=.;
IF V2729 GE 9 THEN V2729=.;
IF V2730 GE 9 THEN V2730=.;
IF V2731 GE 9 THEN V2731=.;
IF V2732 GE 9 THEN V2732=.;
IF V2733 GE 9 THEN V2733=.;
IF V2734 GE 9 THEN V2734=.;
IF V2735 GE 9 THEN V2735=.;
IF V2736 GE 9 THEN V2736=.;
IF V2737 GE 9 THEN V2737=.;
IF V2738 GE 9 THEN V2738=.;
IF V2739 GE 9 THEN V2739=.;
IF V2740 GE 9 THEN V2740=.;
IF V2741 GE 9 THEN V2741=.;
IF V2742 GE 9 THEN V2742=.;
IF V2743 GE 9 THEN V2743=.;
IF V2744 GE 9 THEN V2744=.;
IF V2745 GE 9 THEN V2745=.;
IF V2746 GE 9 THEN V2746=.;
IF V2747 GE 9 THEN V2747=.;
IF V2748 GE 9 THEN V2748=.;
IF V2749 GE 9 THEN V2749=.;
IF V2750 GE 9 THEN V2750=.;
IF V2751 GE 9 THEN V2751=.;
IF V2752 GE 9 THEN V2752=.;
IF V2753 GE 9 THEN V2753=.;
IF V2754 GE 9 THEN V2754=.;
IF V2755 GE 9 THEN V2755=.;
IF V2756 GE 9 THEN V2756=.;
IF V2757 GE 9 THEN V2757=.;
IF V2758 GE 9 THEN V2758=.;
IF V2759 GE 9 THEN V2759=.;
IF V2760 GE 9 THEN V2760=.;
IF V2761 GE 9 THEN V2761=.;
IF V2762 GE 9 THEN V2762=.;
IF V2763 GE 9 THEN V2763=.;
IF V2764 GE 9 THEN V2764=.;
IF V2765 GE 9 THEN V2765=.;
IF V2766 GE 9 THEN V2766=.;
IF V2767 GE 9 THEN V2767=.;
IF V2768 GE 9 THEN V2768=.;
IF V2769 GE 9 THEN V2769=.;
IF V2770 GE 9 THEN V2770=.;
IF V2771 GE 9 THEN V2771=.;
IF V2772 GE 9 THEN V2772=.;
IF V2773 GE 9 THEN V2773=.;
IF V2774 GE 9 THEN V2774=.;
IF V2775 GE 9 THEN V2775=.;
IF V2776 GE 9 THEN V2776=.;
IF V2777_1 GE 9 THEN V2777_1=.;
IF V2777_2 GE 9 THEN V2777_2=.;
IF V2778 GE 9 THEN V2778=.;
IF V2779 GE 9 THEN V2779=.;
IF V2780 GE 9 THEN V2780=.;
IF V2781 GE 9 THEN V2781=.;
IF V2782 GE 9 THEN V2782=.;
IF V2783 GE 9 THEN V2783=.;
IF V2784 GE 9 THEN V2784=.;
IF V2785 GE 9 THEN V2785=.;
IF V2786 GE 9 THEN V2786=.;
IF V2787 GE 9 THEN V2787=.;
IF V2788 GE 9 THEN V2788=.;
IF V2789 GE 9 THEN V2789=.;
IF V2790_1 GE 9 THEN V2790_1=.;
IF V2790_2 GE 9 THEN V2790_2=.;
IF V2791 GE 9 THEN V2791=.;
IF V2792 GE 99 THEN V2792=.;
IF V2793 GE 999 THEN V2793=.;
IF V2794 GE 99 THEN V2794=.;
IF V2795 GE 999 THEN V2795=.;
IF V2798 GE 9 THEN V2798=.;
IF V2799 GE 99 THEN V2799=.;
IF V2800 GE 99 THEN V2800=.;
IF V2801 GE 99 THEN V2801=.;
IF V2802 GE 99 THEN V2802=.;
IF V2803 GE 9 THEN V2803=.;
IF V2804 GE 9 THEN V2804=.;
IF V2805 GE 9 THEN V2805=.;
IF V2806 GE 99 THEN V2806=.;
IF V2807 GE 9 THEN V2807=.;
IF V2808 GE 9 THEN V2808=.;
IF V2809 GE 9 THEN V2809=.;
IF V2810 GE 99 THEN V2810=.;
IF V2811 GE 9 THEN V2811=.;
IF V2812 GE 9 THEN V2812=.;
IF V2814 GE 9 THEN V2814=.;
IF V2815 GE 99 THEN V2815=.;
IF V2816 GE 999 THEN V2816=.;
IF V2817 GE 9 THEN V2817=.;
IF V2818 GE 9 THEN V2818=.;
IF V2819 GE 9 THEN V2819=.;
IF V2820 GE 9 THEN V2820=.;
IF V2821 GE 9 THEN V2821=.;
IF V2822 GE 9 THEN V2822=.;
IF V2823 GE 9 THEN V2823=.;
IF V2824 GE 9 THEN V2824=.;
IF V2825 GE 9 THEN V2825=.;
IF V2826 GE 9 THEN V2826=.;
IF V2827 GE 9 THEN V2827=.;
IF V2828 GE 9 THEN V2828=.;
IF V2829 GE 9 THEN V2829=.;
IF V2830 GE 9 THEN V2830=.;
IF V2831 GE 9 THEN V2831=.;
IF V2832 GE 9 THEN V2832=.;
IF V2833 GE 9 THEN V2833=.;
IF V2834 GE 9 THEN V2834=.;
IF V2835 GE 999 THEN V2835=.;
IF V2837 GE 9 THEN V2837=.;
IF V2838 GE 9 THEN V2838=.;
IF V2839 GE 9 THEN V2839=.;
IF V2840 GE 9 THEN V2840=.;
IF V2841 GE 9 THEN V2841=.;
IF V2842 GE 9 THEN V2842=.;
IF V2843 GE 9 THEN V2843=.;
 
file rawdat lrecl=994;
put    
v2402
v2410
v2423
v2424
v2429
v2430
v2434
v2435
v2439
v2440
v2449
v2450
v2471
v2476
v2477
v2478
v2479
v2480
v2481
v2482
v2498
v2499
v2500
v2501
v2505
v2506
v2507
v2511
v2523
v2524
v2525
v2527
v2528
v2539
v2541
v2542
v2543
v2544
v2557
v2566
v2567
v2577
v2578
v2581
v2584
v2586
v2596
v2597
v2638
v2639
v2640
v2670
v2674
v2675
v2687
v2703
v2709
v2718
v2791
v2823
v2828
v2852
v2911
v2916
v2968
v30096
;

proc means;
run; 
